package zio.aws.synthetics.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class CanaryTimeline(
    created: Optional[Timestamp] = Optional.Absent,
    lastModified: Optional[Timestamp] = Optional.Absent,
    lastStarted: Optional[Timestamp] = Optional.Absent,
    lastStopped: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryTimeline = {
    import CanaryTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryTimeline
      .builder()
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        lastStarted.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStarted)
      .optionallyWith(
        lastStopped.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStopped)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryTimeline.ReadOnly =
    zio.aws.synthetics.model.CanaryTimeline.wrap(buildAwsValue())
}
object CanaryTimeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryTimeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryTimeline =
      zio.aws.synthetics.model.CanaryTimeline(
        created.map(value => value),
        lastModified.map(value => value),
        lastStarted.map(value => value),
        lastStopped.map(value => value)
      )
    def created: Optional[Timestamp]
    def lastModified: Optional[Timestamp]
    def lastStarted: Optional[Timestamp]
    def lastStopped: Optional[Timestamp]
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getLastStarted: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStarted", lastStarted)
    def getLastStopped: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStopped", lastStopped)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryTimeline
  ) extends zio.aws.synthetics.model.CanaryTimeline.ReadOnly {
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
    override val lastModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
    override val lastStarted: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStarted())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
    override val lastStopped: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStopped())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryTimeline
  ): zio.aws.synthetics.model.CanaryTimeline.ReadOnly = new Wrapper(impl)
}
