package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{
  RoleArn,
  CanaryName,
  TagValue,
  MaxSize1024,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateCanaryRequest(
    name: CanaryName,
    code: zio.aws.synthetics.model.CanaryCodeInput,
    artifactS3Location: String,
    executionRoleArn: RoleArn,
    schedule: zio.aws.synthetics.model.CanaryScheduleInput,
    runConfig: Optional[zio.aws.synthetics.model.CanaryRunConfigInput] =
      Optional.Absent,
    successRetentionPeriodInDays: Optional[MaxSize1024] = Optional.Absent,
    failureRetentionPeriodInDays: Optional[MaxSize1024] = Optional.Absent,
    runtimeVersion: String,
    vpcConfig: Optional[zio.aws.synthetics.model.VpcConfigInput] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    artifactConfig: Optional[zio.aws.synthetics.model.ArtifactConfigInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CreateCanaryRequest = {
    import CreateCanaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CreateCanaryRequest
      .builder()
      .name(CanaryName.unwrap(name): java.lang.String)
      .code(code.buildAwsValue())
      .artifactS3Location(artifactS3Location: java.lang.String)
      .executionRoleArn(RoleArn.unwrap(executionRoleArn): java.lang.String)
      .schedule(schedule.buildAwsValue())
      .optionallyWith(runConfig.map(value => value.buildAwsValue()))(
        _.runConfig
      )
      .optionallyWith(
        successRetentionPeriodInDays.map(value =>
          MaxSize1024.unwrap(value): Integer
        )
      )(_.successRetentionPeriodInDays)
      .optionallyWith(
        failureRetentionPeriodInDays.map(value =>
          MaxSize1024.unwrap(value): Integer
        )
      )(_.failureRetentionPeriodInDays)
      .runtimeVersion(runtimeVersion: java.lang.String)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(artifactConfig.map(value => value.buildAwsValue()))(
        _.artifactConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CreateCanaryRequest.ReadOnly =
    zio.aws.synthetics.model.CreateCanaryRequest.wrap(buildAwsValue())
}
object CreateCanaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CreateCanaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CreateCanaryRequest =
      zio.aws.synthetics.model.CreateCanaryRequest(
        name,
        code.asEditable,
        artifactS3Location,
        executionRoleArn,
        schedule.asEditable,
        runConfig.map(value => value.asEditable),
        successRetentionPeriodInDays.map(value => value),
        failureRetentionPeriodInDays.map(value => value),
        runtimeVersion,
        vpcConfig.map(value => value.asEditable),
        tags.map(value => value),
        artifactConfig.map(value => value.asEditable)
      )
    def name: CanaryName
    def code: zio.aws.synthetics.model.CanaryCodeInput.ReadOnly
    def artifactS3Location: String
    def executionRoleArn: RoleArn
    def schedule: zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly
    def runConfig
        : Optional[zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly]
    def successRetentionPeriodInDays: Optional[MaxSize1024]
    def failureRetentionPeriodInDays: Optional[MaxSize1024]
    def runtimeVersion: String
    def vpcConfig: Optional[zio.aws.synthetics.model.VpcConfigInput.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def artifactConfig
        : Optional[zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly]
    def getName: ZIO[Any, Nothing, CanaryName] = ZIO.succeed(name)
    def getCode
        : ZIO[Any, Nothing, zio.aws.synthetics.model.CanaryCodeInput.ReadOnly] =
      ZIO.succeed(code)
    def getArtifactS3Location: ZIO[Any, Nothing, String] =
      ZIO.succeed(artifactS3Location)
    def getExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(executionRoleArn)
    def getSchedule: ZIO[
      Any,
      Nothing,
      zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly
    ] = ZIO.succeed(schedule)
    def getRunConfig: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("runConfig", runConfig)
    def getSuccessRetentionPeriodInDays: ZIO[Any, AwsError, MaxSize1024] =
      AwsError.unwrapOptionField(
        "successRetentionPeriodInDays",
        successRetentionPeriodInDays
      )
    def getFailureRetentionPeriodInDays: ZIO[Any, AwsError, MaxSize1024] =
      AwsError.unwrapOptionField(
        "failureRetentionPeriodInDays",
        failureRetentionPeriodInDays
      )
    def getRuntimeVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(runtimeVersion)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.synthetics.model.VpcConfigInput.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArtifactConfig: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("artifactConfig", artifactConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CreateCanaryRequest
  ) extends zio.aws.synthetics.model.CreateCanaryRequest.ReadOnly {
    override val name: CanaryName =
      zio.aws.synthetics.model.primitives.CanaryName(impl.name())
    override val code: zio.aws.synthetics.model.CanaryCodeInput.ReadOnly =
      zio.aws.synthetics.model.CanaryCodeInput.wrap(impl.code())
    override val artifactS3Location: String = impl.artifactS3Location(): String
    override val executionRoleArn: RoleArn =
      zio.aws.synthetics.model.primitives.RoleArn(impl.executionRoleArn())
    override val schedule
        : zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly =
      zio.aws.synthetics.model.CanaryScheduleInput.wrap(impl.schedule())
    override val runConfig
        : Optional[zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runConfig())
        .map(value => zio.aws.synthetics.model.CanaryRunConfigInput.wrap(value))
    override val successRetentionPeriodInDays: Optional[MaxSize1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successRetentionPeriodInDays())
        .map(value => zio.aws.synthetics.model.primitives.MaxSize1024(value))
    override val failureRetentionPeriodInDays: Optional[MaxSize1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRetentionPeriodInDays())
        .map(value => zio.aws.synthetics.model.primitives.MaxSize1024(value))
    override val runtimeVersion: String = impl.runtimeVersion(): String
    override val vpcConfig
        : Optional[zio.aws.synthetics.model.VpcConfigInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.synthetics.model.VpcConfigInput.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.synthetics.model.primitives.TagKey(
              key
            ) -> zio.aws.synthetics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val artifactConfig
        : Optional[zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactConfig())
        .map(value => zio.aws.synthetics.model.ArtifactConfigInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CreateCanaryRequest
  ): zio.aws.synthetics.model.CreateCanaryRequest.ReadOnly = new Wrapper(impl)
}
