package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCanaryResponse(
    canary: Optional[zio.aws.synthetics.model.Canary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CreateCanaryResponse = {
    import CreateCanaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CreateCanaryResponse
      .builder()
      .optionallyWith(canary.map(value => value.buildAwsValue()))(_.canary)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly =
    zio.aws.synthetics.model.CreateCanaryResponse.wrap(buildAwsValue())
}
object CreateCanaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CreateCanaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CreateCanaryResponse =
      zio.aws.synthetics.model
        .CreateCanaryResponse(canary.map(value => value.asEditable))
    def canary: Optional[zio.aws.synthetics.model.Canary.ReadOnly]
    def getCanary
        : ZIO[Any, AwsError, zio.aws.synthetics.model.Canary.ReadOnly] =
      AwsError.unwrapOptionField("canary", canary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CreateCanaryResponse
  ) extends zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly {
    override val canary: Optional[zio.aws.synthetics.model.Canary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canary())
        .map(value => zio.aws.synthetics.model.Canary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CreateCanaryResponse
  ): zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly = new Wrapper(impl)
}
