package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.CanaryName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteCanaryRequest(
    name: CanaryName,
    deleteLambda: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.DeleteCanaryRequest = {
    import DeleteCanaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.DeleteCanaryRequest
      .builder()
      .name(CanaryName.unwrap(name): java.lang.String)
      .optionallyWith(deleteLambda.map(value => value: java.lang.Boolean))(
        _.deleteLambda
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.DeleteCanaryRequest.ReadOnly =
    zio.aws.synthetics.model.DeleteCanaryRequest.wrap(buildAwsValue())
}
object DeleteCanaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.DeleteCanaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.DeleteCanaryRequest =
      zio.aws.synthetics.model
        .DeleteCanaryRequest(name, deleteLambda.map(value => value))
    def name: CanaryName
    def deleteLambda: Optional[Boolean]
    def getName: ZIO[Any, Nothing, CanaryName] = ZIO.succeed(name)
    def getDeleteLambda: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteLambda", deleteLambda)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.DeleteCanaryRequest
  ) extends zio.aws.synthetics.model.DeleteCanaryRequest.ReadOnly {
    override val name: CanaryName =
      zio.aws.synthetics.model.primitives.CanaryName(impl.name())
    override val deleteLambda: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteLambda())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.DeleteCanaryRequest
  ): zio.aws.synthetics.model.DeleteCanaryRequest.ReadOnly = new Wrapper(impl)
}
