package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{CanaryName, MaxSize100, Token}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeCanariesLastRunRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxSize100] = Optional.Absent,
    names: Optional[Iterable[CanaryName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest = {
    import DescribeCanariesLastRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxSize100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            CanaryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .build()
  }
  def asReadOnly
      : zio.aws.synthetics.model.DescribeCanariesLastRunRequest.ReadOnly =
    zio.aws.synthetics.model.DescribeCanariesLastRunRequest
      .wrap(buildAwsValue())
}
object DescribeCanariesLastRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.DescribeCanariesLastRunRequest =
      zio.aws.synthetics.model.DescribeCanariesLastRunRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        names.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxSize100]
    def names: Optional[List[CanaryName]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxSize100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNames: ZIO[Any, AwsError, List[CanaryName]] =
      AwsError.unwrapOptionField("names", names)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest
  ) extends zio.aws.synthetics.model.DescribeCanariesLastRunRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
    override val maxResults: Optional[MaxSize100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.synthetics.model.primitives.MaxSize100(value))
    override val names: Optional[List[CanaryName]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.synthetics.model.primitives.CanaryName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest
  ): zio.aws.synthetics.model.DescribeCanariesLastRunRequest.ReadOnly =
    new Wrapper(impl)
}
