package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCanariesLastRunResponse(
    canariesLastRun: Optional[
      Iterable[zio.aws.synthetics.model.CanaryLastRun]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunResponse = {
    import DescribeCanariesLastRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunResponse
      .builder()
      .optionallyWith(
        canariesLastRun.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.canariesLastRun)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly =
    zio.aws.synthetics.model.DescribeCanariesLastRunResponse
      .wrap(buildAwsValue())
}
object DescribeCanariesLastRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.DescribeCanariesLastRunResponse =
      zio.aws.synthetics.model.DescribeCanariesLastRunResponse(
        canariesLastRun.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def canariesLastRun
        : Optional[List[zio.aws.synthetics.model.CanaryLastRun.ReadOnly]]
    def nextToken: Optional[Token]
    def getCanariesLastRun: ZIO[Any, AwsError, List[
      zio.aws.synthetics.model.CanaryLastRun.ReadOnly
    ]] = AwsError.unwrapOptionField("canariesLastRun", canariesLastRun)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunResponse
  ) extends zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly {
    override val canariesLastRun
        : Optional[List[zio.aws.synthetics.model.CanaryLastRun.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canariesLastRun())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.CanaryLastRun.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunResponse
  ): zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly =
    new Wrapper(impl)
}
