package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{CanaryName, MaxCanaryResults, Token}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeCanariesRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxCanaryResults] = Optional.Absent,
    names: Optional[Iterable[CanaryName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest = {
    import DescribeCanariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxCanaryResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            CanaryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.DescribeCanariesRequest.ReadOnly =
    zio.aws.synthetics.model.DescribeCanariesRequest.wrap(buildAwsValue())
}
object DescribeCanariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.DescribeCanariesRequest =
      zio.aws.synthetics.model.DescribeCanariesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        names.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxCanaryResults]
    def names: Optional[List[CanaryName]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxCanaryResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNames: ZIO[Any, AwsError, List[CanaryName]] =
      AwsError.unwrapOptionField("names", names)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest
  ) extends zio.aws.synthetics.model.DescribeCanariesRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
    override val maxResults: Optional[MaxCanaryResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.synthetics.model.primitives.MaxCanaryResults(value))
    override val names: Optional[List[CanaryName]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.synthetics.model.primitives.CanaryName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest
  ): zio.aws.synthetics.model.DescribeCanariesRequest.ReadOnly = new Wrapper(
    impl
  )
}
