package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCanariesResponse(
    canaries: Optional[Iterable[zio.aws.synthetics.model.Canary]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.DescribeCanariesResponse = {
    import DescribeCanariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesResponse
      .builder()
      .optionallyWith(
        canaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.canaries)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly =
    zio.aws.synthetics.model.DescribeCanariesResponse.wrap(buildAwsValue())
}
object DescribeCanariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.DescribeCanariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.DescribeCanariesResponse =
      zio.aws.synthetics.model.DescribeCanariesResponse(
        canaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def canaries: Optional[List[zio.aws.synthetics.model.Canary.ReadOnly]]
    def nextToken: Optional[Token]
    def getCanaries
        : ZIO[Any, AwsError, List[zio.aws.synthetics.model.Canary.ReadOnly]] =
      AwsError.unwrapOptionField("canaries", canaries)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesResponse
  ) extends zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly {
    override val canaries
        : Optional[List[zio.aws.synthetics.model.Canary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.Canary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeCanariesResponse
  ): zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly = new Wrapper(
    impl
  )
}
