package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{MaxSize100, Token}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeRuntimeVersionsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxSize100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest = {
    import DescribeRuntimeVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxSize100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.synthetics.model.DescribeRuntimeVersionsRequest.ReadOnly =
    zio.aws.synthetics.model.DescribeRuntimeVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeRuntimeVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.DescribeRuntimeVersionsRequest =
      zio.aws.synthetics.model.DescribeRuntimeVersionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxSize100]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxSize100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest
  ) extends zio.aws.synthetics.model.DescribeRuntimeVersionsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
    override val maxResults: Optional[MaxSize100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.synthetics.model.primitives.MaxSize100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest
  ): zio.aws.synthetics.model.DescribeRuntimeVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
