package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRuntimeVersionsResponse(
    runtimeVersions: Optional[
      Iterable[zio.aws.synthetics.model.RuntimeVersion]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsResponse = {
    import DescribeRuntimeVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsResponse
      .builder()
      .optionallyWith(
        runtimeVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runtimeVersions)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly =
    zio.aws.synthetics.model.DescribeRuntimeVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeRuntimeVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.DescribeRuntimeVersionsResponse =
      zio.aws.synthetics.model.DescribeRuntimeVersionsResponse(
        runtimeVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def runtimeVersions
        : Optional[List[zio.aws.synthetics.model.RuntimeVersion.ReadOnly]]
    def nextToken: Optional[Token]
    def getRuntimeVersions: ZIO[Any, AwsError, List[
      zio.aws.synthetics.model.RuntimeVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("runtimeVersions", runtimeVersions)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsResponse
  ) extends zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly {
    override val runtimeVersions
        : Optional[List[zio.aws.synthetics.model.RuntimeVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.RuntimeVersion.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsResponse
  ): zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
