package zio.aws.synthetics.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionMode {
  def unwrap: software.amazon.awssdk.services.synthetics.model.EncryptionMode
}
object EncryptionMode {
  def wrap(
      value: software.amazon.awssdk.services.synthetics.model.EncryptionMode
  ): zio.aws.synthetics.model.EncryptionMode = value match {
    case software.amazon.awssdk.services.synthetics.model.EncryptionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.synthetics.model.EncryptionMode.SSE_S3 =>
      val r = SSE_S3
      r
    case software.amazon.awssdk.services.synthetics.model.EncryptionMode.SSE_KMS =>
      val r = SSE_KMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.synthetics.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.EncryptionMode =
      software.amazon.awssdk.services.synthetics.model.EncryptionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SSE_S3 extends zio.aws.synthetics.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.EncryptionMode =
      software.amazon.awssdk.services.synthetics.model.EncryptionMode.SSE_S3
  }
  case object SSE_KMS extends zio.aws.synthetics.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.EncryptionMode =
      software.amazon.awssdk.services.synthetics.model.EncryptionMode.SSE_KMS
  }
}
