package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.CanaryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCanaryRequest(name: CanaryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.GetCanaryRequest = {
    import GetCanaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.GetCanaryRequest
      .builder()
      .name(CanaryName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.GetCanaryRequest.ReadOnly =
    zio.aws.synthetics.model.GetCanaryRequest.wrap(buildAwsValue())
}
object GetCanaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.GetCanaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.GetCanaryRequest =
      zio.aws.synthetics.model.GetCanaryRequest(name)
    def name: CanaryName
    def getName: ZIO[Any, Nothing, CanaryName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryRequest
  ) extends zio.aws.synthetics.model.GetCanaryRequest.ReadOnly {
    override val name: CanaryName =
      zio.aws.synthetics.model.primitives.CanaryName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryRequest
  ): zio.aws.synthetics.model.GetCanaryRequest.ReadOnly = new Wrapper(impl)
}
