package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCanaryResponse(
    canary: Optional[zio.aws.synthetics.model.Canary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.GetCanaryResponse = {
    import GetCanaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.GetCanaryResponse
      .builder()
      .optionallyWith(canary.map(value => value.buildAwsValue()))(_.canary)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.GetCanaryResponse.ReadOnly =
    zio.aws.synthetics.model.GetCanaryResponse.wrap(buildAwsValue())
}
object GetCanaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.GetCanaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.GetCanaryResponse =
      zio.aws.synthetics.model
        .GetCanaryResponse(canary.map(value => value.asEditable))
    def canary: Optional[zio.aws.synthetics.model.Canary.ReadOnly]
    def getCanary
        : ZIO[Any, AwsError, zio.aws.synthetics.model.Canary.ReadOnly] =
      AwsError.unwrapOptionField("canary", canary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryResponse
  ) extends zio.aws.synthetics.model.GetCanaryResponse.ReadOnly {
    override val canary: Optional[zio.aws.synthetics.model.Canary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canary())
        .map(value => zio.aws.synthetics.model.Canary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryResponse
  ): zio.aws.synthetics.model.GetCanaryResponse.ReadOnly = new Wrapper(impl)
}
