package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{MaxSize100, Token, CanaryName}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetCanaryRunsRequest(
    name: CanaryName,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxSize100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest = {
    import GetCanaryRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest
      .builder()
      .name(CanaryName.unwrap(name): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxSize100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.GetCanaryRunsRequest.ReadOnly =
    zio.aws.synthetics.model.GetCanaryRunsRequest.wrap(buildAwsValue())
}
object GetCanaryRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.GetCanaryRunsRequest =
      zio.aws.synthetics.model.GetCanaryRunsRequest(
        name,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: CanaryName
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxSize100]
    def getName: ZIO[Any, Nothing, CanaryName] = ZIO.succeed(name)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxSize100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest
  ) extends zio.aws.synthetics.model.GetCanaryRunsRequest.ReadOnly {
    override val name: CanaryName =
      zio.aws.synthetics.model.primitives.CanaryName(impl.name())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
    override val maxResults: Optional[MaxSize100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.synthetics.model.primitives.MaxSize100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest
  ): zio.aws.synthetics.model.GetCanaryRunsRequest.ReadOnly = new Wrapper(impl)
}
