package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCanaryRunsResponse(
    canaryRuns: Optional[Iterable[zio.aws.synthetics.model.CanaryRun]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.GetCanaryRunsResponse = {
    import GetCanaryRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.GetCanaryRunsResponse
      .builder()
      .optionallyWith(
        canaryRuns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.canaryRuns)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly =
    zio.aws.synthetics.model.GetCanaryRunsResponse.wrap(buildAwsValue())
}
object GetCanaryRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.GetCanaryRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.GetCanaryRunsResponse =
      zio.aws.synthetics.model.GetCanaryRunsResponse(
        canaryRuns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def canaryRuns: Optional[List[zio.aws.synthetics.model.CanaryRun.ReadOnly]]
    def nextToken: Optional[Token]
    def getCanaryRuns: ZIO[Any, AwsError, List[
      zio.aws.synthetics.model.CanaryRun.ReadOnly
    ]] = AwsError.unwrapOptionField("canaryRuns", canaryRuns)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryRunsResponse
  ) extends zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly {
    override val canaryRuns
        : Optional[List[zio.aws.synthetics.model.CanaryRun.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canaryRuns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.CanaryRun.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.synthetics.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.GetCanaryRunsResponse
  ): zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly = new Wrapper(impl)
}
