package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.CanaryArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: CanaryArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(CanaryArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.synthetics.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.ListTagsForResourceRequest =
      zio.aws.synthetics.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: CanaryArn
    def getResourceArn: ZIO[Any, Nothing, CanaryArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.ListTagsForResourceRequest
  ) extends zio.aws.synthetics.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: CanaryArn =
      zio.aws.synthetics.model.primitives.CanaryArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.ListTagsForResourceRequest
  ): zio.aws.synthetics.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
