package zio.aws.synthetics.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class RuntimeVersion(
    versionName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    releaseDate: Optional[Timestamp] = Optional.Absent,
    deprecationDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.RuntimeVersion = {
    import RuntimeVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.RuntimeVersion
      .builder()
      .optionallyWith(versionName.map(value => value: java.lang.String))(
        _.versionName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        releaseDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.releaseDate)
      .optionallyWith(
        deprecationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.deprecationDate)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.RuntimeVersion.ReadOnly =
    zio.aws.synthetics.model.RuntimeVersion.wrap(buildAwsValue())
}
object RuntimeVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.RuntimeVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.RuntimeVersion =
      zio.aws.synthetics.model.RuntimeVersion(
        versionName.map(value => value),
        description.map(value => value),
        releaseDate.map(value => value),
        deprecationDate.map(value => value)
      )
    def versionName: Optional[String]
    def description: Optional[String]
    def releaseDate: Optional[Timestamp]
    def deprecationDate: Optional[Timestamp]
    def getVersionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getReleaseDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("releaseDate", releaseDate)
    def getDeprecationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deprecationDate", deprecationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.RuntimeVersion
  ) extends zio.aws.synthetics.model.RuntimeVersion.ReadOnly {
    override val versionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val releaseDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseDate())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
    override val deprecationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deprecationDate())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.RuntimeVersion
  ): zio.aws.synthetics.model.RuntimeVersion.ReadOnly = new Wrapper(impl)
}
