package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.KmsKeyArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3EncryptionConfig(
    encryptionMode: Optional[zio.aws.synthetics.model.EncryptionMode] =
      Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.S3EncryptionConfig = {
    import S3EncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.S3EncryptionConfig
      .builder()
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.S3EncryptionConfig.ReadOnly =
    zio.aws.synthetics.model.S3EncryptionConfig.wrap(buildAwsValue())
}
object S3EncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.S3EncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.S3EncryptionConfig =
      zio.aws.synthetics.model.S3EncryptionConfig(
        encryptionMode.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def encryptionMode: Optional[zio.aws.synthetics.model.EncryptionMode]
    def kmsKeyArn: Optional[KmsKeyArn]
    def getEncryptionMode
        : ZIO[Any, AwsError, zio.aws.synthetics.model.EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.S3EncryptionConfig
  ) extends zio.aws.synthetics.model.S3EncryptionConfig.ReadOnly {
    override val encryptionMode
        : Optional[zio.aws.synthetics.model.EncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value => zio.aws.synthetics.model.EncryptionMode.wrap(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.synthetics.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.S3EncryptionConfig
  ): zio.aws.synthetics.model.S3EncryptionConfig.ReadOnly = new Wrapper(impl)
}
