package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.CanaryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartCanaryRequest(name: CanaryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.StartCanaryRequest = {
    import StartCanaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.StartCanaryRequest
      .builder()
      .name(CanaryName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.StartCanaryRequest.ReadOnly =
    zio.aws.synthetics.model.StartCanaryRequest.wrap(buildAwsValue())
}
object StartCanaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.StartCanaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.StartCanaryRequest =
      zio.aws.synthetics.model.StartCanaryRequest(name)
    def name: CanaryName
    def getName: ZIO[Any, Nothing, CanaryName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.StartCanaryRequest
  ) extends zio.aws.synthetics.model.StartCanaryRequest.ReadOnly {
    override val name: CanaryName =
      zio.aws.synthetics.model.primitives.CanaryName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.StartCanaryRequest
  ): zio.aws.synthetics.model.StartCanaryRequest.ReadOnly = new Wrapper(impl)
}
