package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.CanaryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopCanaryRequest(name: CanaryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.StopCanaryRequest = {
    import StopCanaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.StopCanaryRequest
      .builder()
      .name(CanaryName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.StopCanaryRequest.ReadOnly =
    zio.aws.synthetics.model.StopCanaryRequest.wrap(buildAwsValue())
}
object StopCanaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.StopCanaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.StopCanaryRequest =
      zio.aws.synthetics.model.StopCanaryRequest(name)
    def name: CanaryName
    def getName: ZIO[Any, Nothing, CanaryName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.StopCanaryRequest
  ) extends zio.aws.synthetics.model.StopCanaryRequest.ReadOnly {
    override val name: CanaryName =
      zio.aws.synthetics.model.primitives.CanaryName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.StopCanaryRequest
  ): zio.aws.synthetics.model.StopCanaryRequest.ReadOnly = new Wrapper(impl)
}
