package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.{TagValue, TagKey, CanaryArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: CanaryArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.TagResourceRequest
      .builder()
      .resourceArn(CanaryArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.TagResourceRequest.ReadOnly =
    zio.aws.synthetics.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.TagResourceRequest =
      zio.aws.synthetics.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: CanaryArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, CanaryArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.TagResourceRequest
  ) extends zio.aws.synthetics.model.TagResourceRequest.ReadOnly {
    override val resourceArn: CanaryArn =
      zio.aws.synthetics.model.primitives.CanaryArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.synthetics.model.primitives
          .TagKey(key) -> zio.aws.synthetics.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.TagResourceRequest
  ): zio.aws.synthetics.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
