package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.{TagKey, CanaryArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: CanaryArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.UntagResourceRequest
      .builder()
      .resourceArn(CanaryArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.UntagResourceRequest.ReadOnly =
    zio.aws.synthetics.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.UntagResourceRequest =
      zio.aws.synthetics.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: CanaryArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, CanaryArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.UntagResourceRequest
  ) extends zio.aws.synthetics.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: CanaryArn =
      zio.aws.synthetics.model.primitives.CanaryArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.synthetics.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.UntagResourceRequest
  ): zio.aws.synthetics.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
