package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{MaxSize1024, RoleArn, CanaryName}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateCanaryRequest(
    name: CanaryName,
    code: Optional[zio.aws.synthetics.model.CanaryCodeInput] = Optional.Absent,
    executionRoleArn: Optional[RoleArn] = Optional.Absent,
    runtimeVersion: Optional[String] = Optional.Absent,
    schedule: Optional[zio.aws.synthetics.model.CanaryScheduleInput] =
      Optional.Absent,
    runConfig: Optional[zio.aws.synthetics.model.CanaryRunConfigInput] =
      Optional.Absent,
    successRetentionPeriodInDays: Optional[MaxSize1024] = Optional.Absent,
    failureRetentionPeriodInDays: Optional[MaxSize1024] = Optional.Absent,
    vpcConfig: Optional[zio.aws.synthetics.model.VpcConfigInput] =
      Optional.Absent,
    visualReference: Optional[zio.aws.synthetics.model.VisualReferenceInput] =
      Optional.Absent,
    artifactS3Location: Optional[String] = Optional.Absent,
    artifactConfig: Optional[zio.aws.synthetics.model.ArtifactConfigInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.UpdateCanaryRequest = {
    import UpdateCanaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.UpdateCanaryRequest
      .builder()
      .name(CanaryName.unwrap(name): java.lang.String)
      .optionallyWith(code.map(value => value.buildAwsValue()))(_.code)
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(runtimeVersion.map(value => value: java.lang.String))(
        _.runtimeVersion
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(runConfig.map(value => value.buildAwsValue()))(
        _.runConfig
      )
      .optionallyWith(
        successRetentionPeriodInDays.map(value =>
          MaxSize1024.unwrap(value): Integer
        )
      )(_.successRetentionPeriodInDays)
      .optionallyWith(
        failureRetentionPeriodInDays.map(value =>
          MaxSize1024.unwrap(value): Integer
        )
      )(_.failureRetentionPeriodInDays)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(visualReference.map(value => value.buildAwsValue()))(
        _.visualReference
      )
      .optionallyWith(artifactS3Location.map(value => value: java.lang.String))(
        _.artifactS3Location
      )
      .optionallyWith(artifactConfig.map(value => value.buildAwsValue()))(
        _.artifactConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.UpdateCanaryRequest.ReadOnly =
    zio.aws.synthetics.model.UpdateCanaryRequest.wrap(buildAwsValue())
}
object UpdateCanaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.UpdateCanaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.UpdateCanaryRequest =
      zio.aws.synthetics.model.UpdateCanaryRequest(
        name,
        code.map(value => value.asEditable),
        executionRoleArn.map(value => value),
        runtimeVersion.map(value => value),
        schedule.map(value => value.asEditable),
        runConfig.map(value => value.asEditable),
        successRetentionPeriodInDays.map(value => value),
        failureRetentionPeriodInDays.map(value => value),
        vpcConfig.map(value => value.asEditable),
        visualReference.map(value => value.asEditable),
        artifactS3Location.map(value => value),
        artifactConfig.map(value => value.asEditable)
      )
    def name: CanaryName
    def code: Optional[zio.aws.synthetics.model.CanaryCodeInput.ReadOnly]
    def executionRoleArn: Optional[RoleArn]
    def runtimeVersion: Optional[String]
    def schedule
        : Optional[zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly]
    def runConfig
        : Optional[zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly]
    def successRetentionPeriodInDays: Optional[MaxSize1024]
    def failureRetentionPeriodInDays: Optional[MaxSize1024]
    def vpcConfig: Optional[zio.aws.synthetics.model.VpcConfigInput.ReadOnly]
    def visualReference
        : Optional[zio.aws.synthetics.model.VisualReferenceInput.ReadOnly]
    def artifactS3Location: Optional[String]
    def artifactConfig
        : Optional[zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly]
    def getName: ZIO[Any, Nothing, CanaryName] = ZIO.succeed(name)
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryCodeInput.ReadOnly
    ] = AwsError.unwrapOptionField("code", code)
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getRuntimeVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeVersion", runtimeVersion)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getRunConfig: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("runConfig", runConfig)
    def getSuccessRetentionPeriodInDays: ZIO[Any, AwsError, MaxSize1024] =
      AwsError.unwrapOptionField(
        "successRetentionPeriodInDays",
        successRetentionPeriodInDays
      )
    def getFailureRetentionPeriodInDays: ZIO[Any, AwsError, MaxSize1024] =
      AwsError.unwrapOptionField(
        "failureRetentionPeriodInDays",
        failureRetentionPeriodInDays
      )
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.synthetics.model.VpcConfigInput.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getVisualReference: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.VisualReferenceInput.ReadOnly
    ] = AwsError.unwrapOptionField("visualReference", visualReference)
    def getArtifactS3Location: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactS3Location", artifactS3Location)
    def getArtifactConfig: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("artifactConfig", artifactConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.UpdateCanaryRequest
  ) extends zio.aws.synthetics.model.UpdateCanaryRequest.ReadOnly {
    override val name: CanaryName =
      zio.aws.synthetics.model.primitives.CanaryName(impl.name())
    override val code
        : Optional[zio.aws.synthetics.model.CanaryCodeInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.synthetics.model.CanaryCodeInput.wrap(value))
    override val executionRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => zio.aws.synthetics.model.primitives.RoleArn(value))
    override val runtimeVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeVersion())
      .map(value => value: String)
    override val schedule
        : Optional[zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.synthetics.model.CanaryScheduleInput.wrap(value))
    override val runConfig
        : Optional[zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runConfig())
        .map(value => zio.aws.synthetics.model.CanaryRunConfigInput.wrap(value))
    override val successRetentionPeriodInDays: Optional[MaxSize1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successRetentionPeriodInDays())
        .map(value => zio.aws.synthetics.model.primitives.MaxSize1024(value))
    override val failureRetentionPeriodInDays: Optional[MaxSize1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRetentionPeriodInDays())
        .map(value => zio.aws.synthetics.model.primitives.MaxSize1024(value))
    override val vpcConfig
        : Optional[zio.aws.synthetics.model.VpcConfigInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.synthetics.model.VpcConfigInput.wrap(value))
    override val visualReference
        : Optional[zio.aws.synthetics.model.VisualReferenceInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visualReference())
        .map(value => zio.aws.synthetics.model.VisualReferenceInput.wrap(value))
    override val artifactS3Location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactS3Location())
      .map(value => value: String)
    override val artifactConfig
        : Optional[zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactConfig())
        .map(value => zio.aws.synthetics.model.ArtifactConfigInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.UpdateCanaryRequest
  ): zio.aws.synthetics.model.UpdateCanaryRequest.ReadOnly = new Wrapper(impl)
}
