package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VisualReferenceInput(
    baseScreenshots: Optional[
      Iterable[zio.aws.synthetics.model.BaseScreenshot]
    ] = Optional.Absent,
    baseCanaryRunId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.VisualReferenceInput = {
    import VisualReferenceInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.VisualReferenceInput
      .builder()
      .optionallyWith(
        baseScreenshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.baseScreenshots)
      .baseCanaryRunId(baseCanaryRunId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.VisualReferenceInput.ReadOnly =
    zio.aws.synthetics.model.VisualReferenceInput.wrap(buildAwsValue())
}
object VisualReferenceInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.VisualReferenceInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.VisualReferenceInput =
      zio.aws.synthetics.model.VisualReferenceInput(
        baseScreenshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        baseCanaryRunId
      )
    def baseScreenshots
        : Optional[List[zio.aws.synthetics.model.BaseScreenshot.ReadOnly]]
    def baseCanaryRunId: String
    def getBaseScreenshots: ZIO[Any, AwsError, List[
      zio.aws.synthetics.model.BaseScreenshot.ReadOnly
    ]] = AwsError.unwrapOptionField("baseScreenshots", baseScreenshots)
    def getBaseCanaryRunId: ZIO[Any, Nothing, String] =
      ZIO.succeed(baseCanaryRunId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.VisualReferenceInput
  ) extends zio.aws.synthetics.model.VisualReferenceInput.ReadOnly {
    override val baseScreenshots
        : Optional[List[zio.aws.synthetics.model.BaseScreenshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseScreenshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.BaseScreenshot.wrap(item)
          }.toList
        )
    override val baseCanaryRunId: String = impl.baseCanaryRunId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.VisualReferenceInput
  ): zio.aws.synthetics.model.VisualReferenceInput.ReadOnly = new Wrapper(impl)
}
