package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VisualReferenceOutput(
    baseScreenshots: Optional[
      Iterable[zio.aws.synthetics.model.BaseScreenshot]
    ] = Optional.Absent,
    baseCanaryRunId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.VisualReferenceOutput = {
    import VisualReferenceOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.VisualReferenceOutput
      .builder()
      .optionallyWith(
        baseScreenshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.baseScreenshots)
      .optionallyWith(baseCanaryRunId.map(value => value: java.lang.String))(
        _.baseCanaryRunId
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.VisualReferenceOutput.ReadOnly =
    zio.aws.synthetics.model.VisualReferenceOutput.wrap(buildAwsValue())
}
object VisualReferenceOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.VisualReferenceOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.VisualReferenceOutput =
      zio.aws.synthetics.model.VisualReferenceOutput(
        baseScreenshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        baseCanaryRunId.map(value => value)
      )
    def baseScreenshots
        : Optional[List[zio.aws.synthetics.model.BaseScreenshot.ReadOnly]]
    def baseCanaryRunId: Optional[String]
    def getBaseScreenshots: ZIO[Any, AwsError, List[
      zio.aws.synthetics.model.BaseScreenshot.ReadOnly
    ]] = AwsError.unwrapOptionField("baseScreenshots", baseScreenshots)
    def getBaseCanaryRunId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("baseCanaryRunId", baseCanaryRunId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.VisualReferenceOutput
  ) extends zio.aws.synthetics.model.VisualReferenceOutput.ReadOnly {
    override val baseScreenshots
        : Optional[List[zio.aws.synthetics.model.BaseScreenshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseScreenshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.BaseScreenshot.wrap(item)
          }.toList
        )
    override val baseCanaryRunId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.baseCanaryRunId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.VisualReferenceOutput
  ): zio.aws.synthetics.model.VisualReferenceOutput.ReadOnly = new Wrapper(impl)
}
