package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.{SecurityGroupId, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConfigInput(
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.VpcConfigInput = {
    import VpcConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.VpcConfigInput
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.VpcConfigInput.ReadOnly =
    zio.aws.synthetics.model.VpcConfigInput.wrap(buildAwsValue())
}
object VpcConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.VpcConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.VpcConfigInput =
      zio.aws.synthetics.model.VpcConfigInput(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value)
      )
    def subnetIds: Optional[List[SubnetId]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.VpcConfigInput
  ) extends zio.aws.synthetics.model.VpcConfigInput.ReadOnly {
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.synthetics.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.VpcConfigInput
  ): zio.aws.synthetics.model.VpcConfigInput.ReadOnly = new Wrapper(impl)
}
