package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.{SecurityGroupId, SubnetId, VpcId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConfigOutput(
    vpcId: Optional[VpcId] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.VpcConfigOutput = {
    import VpcConfigOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.VpcConfigOutput
      .builder()
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.VpcConfigOutput.ReadOnly =
    zio.aws.synthetics.model.VpcConfigOutput.wrap(buildAwsValue())
}
object VpcConfigOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.VpcConfigOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.VpcConfigOutput =
      zio.aws.synthetics.model.VpcConfigOutput(
        vpcId.map(value => value),
        subnetIds.map(value => value),
        securityGroupIds.map(value => value)
      )
    def vpcId: Optional[VpcId]
    def subnetIds: Optional[List[SubnetId]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.VpcConfigOutput
  ) extends zio.aws.synthetics.model.VpcConfigOutput.ReadOnly {
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.synthetics.model.primitives.VpcId(value))
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.synthetics.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.VpcConfigOutput
  ): zio.aws.synthetics.model.VpcConfigOutput.ReadOnly = new Wrapper(impl)
}
