package zio.aws.synthetics
import zio.aws.synthetics.model.primitives.SubnetId.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.synthetics.model.primitives.{
  SubnetId,
  SecurityGroupId,
  CanaryName,
  TagValue,
  EnvironmentVariableName,
  BaseScreenshotConfigIgnoreCoordinate,
  EnvironmentVariableValue,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object BaseScreenshotConfigIgnoreCoordinate extends Subtype[String]
    type BaseScreenshotConfigIgnoreCoordinate =
      zio.aws.synthetics.model.primitives.BaseScreenshotConfigIgnoreCoordinate.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.synthetics.model.primitives.Blob.Type
    object CanaryArn extends Subtype[String]
    type CanaryArn = zio.aws.synthetics.model.primitives.CanaryArn.Type
    object CanaryName extends Subtype[String]
    type CanaryName = zio.aws.synthetics.model.primitives.CanaryName.Type
    object CodeHandler extends Subtype[String]
    type CodeHandler = zio.aws.synthetics.model.primitives.CodeHandler.Type
    object EnvironmentVariableName extends Subtype[String]
    type EnvironmentVariableName =
      zio.aws.synthetics.model.primitives.EnvironmentVariableName.Type
    object EnvironmentVariableValue extends Subtype[String]
    type EnvironmentVariableValue =
      zio.aws.synthetics.model.primitives.EnvironmentVariableValue.Type
    object FunctionArn extends Subtype[String]
    type FunctionArn = zio.aws.synthetics.model.primitives.FunctionArn.Type
    object KmsKeyArn extends Subtype[String]
    type KmsKeyArn = zio.aws.synthetics.model.primitives.KmsKeyArn.Type
    object MaxCanaryResults extends Subtype[Int]
    type MaxCanaryResults =
      zio.aws.synthetics.model.primitives.MaxCanaryResults.Type
    object MaxFifteenMinutesInSeconds extends Subtype[Int]
    type MaxFifteenMinutesInSeconds =
      zio.aws.synthetics.model.primitives.MaxFifteenMinutesInSeconds.Type
    object MaxOneYearInSeconds extends Subtype[Long]
    type MaxOneYearInSeconds =
      zio.aws.synthetics.model.primitives.MaxOneYearInSeconds.Type
    object MaxSize100 extends Subtype[Int]
    type MaxSize100 = zio.aws.synthetics.model.primitives.MaxSize100.Type
    object MaxSize1024 extends Subtype[Int]
    type MaxSize1024 = zio.aws.synthetics.model.primitives.MaxSize1024.Type
    object MaxSize3008 extends Subtype[Int]
    type MaxSize3008 = zio.aws.synthetics.model.primitives.MaxSize3008.Type
    type NullableBoolean = Boolean
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.synthetics.model.primitives.RoleArn.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.synthetics.model.primitives.SecurityGroupId.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.synthetics.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.synthetics.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.synthetics.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.synthetics.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.synthetics.model.primitives.Token.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.synthetics.model.primitives.UUID.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.synthetics.model.primitives.VpcId.Type
  }
  type BaseScreenshotIgnoreCoordinates =
    List[BaseScreenshotConfigIgnoreCoordinate]
  type BaseScreenshots = List[zio.aws.synthetics.model.BaseScreenshot]
  type Canaries = List[zio.aws.synthetics.model.Canary]
  type CanariesLastRun = List[zio.aws.synthetics.model.CanaryLastRun]
  type CanaryRuns = List[zio.aws.synthetics.model.CanaryRun]
  type DescribeCanariesLastRunNameFilter = List[CanaryName]
  type DescribeCanariesNameFilter = List[CanaryName]
  type EnvironmentVariablesMap =
    Map[EnvironmentVariableName, EnvironmentVariableValue]
  type RuntimeVersionList = List[zio.aws.synthetics.model.RuntimeVersion]
  type SecurityGroupIds = List[SecurityGroupId]
  type SubnetIds = List[SubnetId]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
