package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AnalyzeIdRequest(
    documentPages: Iterable[zio.aws.textract.model.Document]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeIdRequest = {
    import AnalyzeIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeIdRequest
      .builder()
      .documentPages(documentPages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeIdRequest.ReadOnly =
    zio.aws.textract.model.AnalyzeIdRequest.wrap(buildAwsValue())
}
object AnalyzeIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeIdRequest =
      zio.aws.textract.model.AnalyzeIdRequest(documentPages.map { item =>
        item.asEditable
      })
    def documentPages: List[zio.aws.textract.model.Document.ReadOnly]
    def getDocumentPages
        : ZIO[Any, Nothing, List[zio.aws.textract.model.Document.ReadOnly]] =
      ZIO.succeed(documentPages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeIdRequest
  ) extends zio.aws.textract.model.AnalyzeIdRequest.ReadOnly {
    override val documentPages: List[zio.aws.textract.model.Document.ReadOnly] =
      impl
        .documentPages()
        .asScala
        .map { item =>
          zio.aws.textract.model.Document.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeIdRequest
  ): zio.aws.textract.model.AnalyzeIdRequest.ReadOnly = new Wrapper(impl)
}
