package zio.aws.textract.model
import scala.jdk.CollectionConverters._
sealed trait BlockType {
  def unwrap: software.amazon.awssdk.services.textract.model.BlockType
}
object BlockType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.BlockType
  ): zio.aws.textract.model.BlockType = value match {
    case software.amazon.awssdk.services.textract.model.BlockType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.BlockType.KEY_VALUE_SET =>
      val r = KEY_VALUE_SET
      r
    case software.amazon.awssdk.services.textract.model.BlockType.PAGE =>
      val r = PAGE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LINE =>
      val r = LINE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.WORD =>
      val r = WORD
      r
    case software.amazon.awssdk.services.textract.model.BlockType.TABLE =>
      val r = TABLE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.CELL =>
      val r = CELL
      r
    case software.amazon.awssdk.services.textract.model.BlockType.SELECTION_ELEMENT =>
      val r = SELECTION_ELEMENT
      r
    case software.amazon.awssdk.services.textract.model.BlockType.MERGED_CELL =>
      val r = MERGED_CELL
      r
    case software.amazon.awssdk.services.textract.model.BlockType.TITLE =>
      val r = TITLE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.QUERY =>
      val r = QUERY
      r
    case software.amazon.awssdk.services.textract.model.BlockType.QUERY_RESULT =>
      val r = QUERY_RESULT
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.UNKNOWN_TO_SDK_VERSION
  }
  case object KEY_VALUE_SET extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.KEY_VALUE_SET
  }
  case object PAGE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.PAGE
  }
  case object LINE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LINE
  }
  case object WORD extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.WORD
  }
  case object TABLE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.TABLE
  }
  case object CELL extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.CELL
  }
  case object SELECTION_ELEMENT extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.SELECTION_ELEMENT
  }
  case object MERGED_CELL extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.MERGED_CELL
  }
  case object TITLE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.TITLE
  }
  case object QUERY extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.QUERY
  }
  case object QUERY_RESULT extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.QUERY_RESULT
  }
}
