package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NormalizedValue(
    value: Optional[String] = Optional.Absent,
    valueType: Optional[zio.aws.textract.model.ValueType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.NormalizedValue = {
    import NormalizedValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.NormalizedValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(valueType.map(value => value.unwrap))(_.valueType)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.NormalizedValue.ReadOnly =
    zio.aws.textract.model.NormalizedValue.wrap(buildAwsValue())
}
object NormalizedValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.NormalizedValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.NormalizedValue =
      zio.aws.textract.model.NormalizedValue(
        value.map(value => value),
        valueType.map(value => value)
      )
    def value: Optional[String]
    def valueType: Optional[zio.aws.textract.model.ValueType]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getValueType: ZIO[Any, AwsError, zio.aws.textract.model.ValueType] =
      AwsError.unwrapOptionField("valueType", valueType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.NormalizedValue
  ) extends zio.aws.textract.model.NormalizedValue.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val valueType: Optional[zio.aws.textract.model.ValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueType())
        .map(value => zio.aws.textract.model.ValueType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.NormalizedValue
  ): zio.aws.textract.model.NormalizedValue.ReadOnly = new Wrapper(impl)
}
