package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{QueryPage, QueryInput}
import scala.jdk.CollectionConverters._
final case class Query(
    text: QueryInput,
    alias: Optional[QueryInput] = Optional.Absent,
    pages: Optional[Iterable[QueryPage]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.textract.model.Query = {
    import Query.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Query
      .builder()
      .text(QueryInput.unwrap(text): java.lang.String)
      .optionallyWith(
        alias.map(value => QueryInput.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(
        pages.map(value =>
          value.map { item =>
            QueryPage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.pages)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Query.ReadOnly =
    zio.aws.textract.model.Query.wrap(buildAwsValue())
}
object Query {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.textract.model.Query] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Query = zio.aws.textract.model
      .Query(text, alias.map(value => value), pages.map(value => value))
    def text: QueryInput
    def alias: Optional[QueryInput]
    def pages: Optional[List[QueryPage]]
    def getText: ZIO[Any, Nothing, QueryInput] = ZIO.succeed(text)
    def getAlias: ZIO[Any, AwsError, QueryInput] =
      AwsError.unwrapOptionField("alias", alias)
    def getPages: ZIO[Any, AwsError, List[QueryPage]] =
      AwsError.unwrapOptionField("pages", pages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Query
  ) extends zio.aws.textract.model.Query.ReadOnly {
    override val text: QueryInput =
      zio.aws.textract.model.primitives.QueryInput(impl.text())
    override val alias: Optional[QueryInput] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.textract.model.primitives.QueryInput(value))
    override val pages: Optional[List[QueryPage]] = zio.aws.core.internal
      .optionalFromNullable(impl.pages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.primitives.QueryPage(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Query
  ): zio.aws.textract.model.Query.ReadOnly = new Wrapper(impl)
}
