package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyzeDocumentResponse(
    documentMetadata: Optional[zio.aws.textract.model.DocumentMetadata] =
      Optional.Absent,
    blocks: Optional[Iterable[zio.aws.textract.model.Block]] = Optional.Absent,
    humanLoopActivationOutput: Optional[
      zio.aws.textract.model.HumanLoopActivationOutput
    ] = Optional.Absent,
    analyzeDocumentModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse = {
    import AnalyzeDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(
        blocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocks)
      .optionallyWith(
        humanLoopActivationOutput.map(value => value.buildAwsValue())
      )(_.humanLoopActivationOutput)
      .optionallyWith(
        analyzeDocumentModelVersion.map(value => value: java.lang.String)
      )(_.analyzeDocumentModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly =
    zio.aws.textract.model.AnalyzeDocumentResponse.wrap(buildAwsValue())
}
object AnalyzeDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeDocumentResponse =
      zio.aws.textract.model.AnalyzeDocumentResponse(
        documentMetadata.map(value => value.asEditable),
        blocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        humanLoopActivationOutput.map(value => value.asEditable),
        analyzeDocumentModelVersion.map(value => value)
      )
    def documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]]
    def humanLoopActivationOutput
        : Optional[zio.aws.textract.model.HumanLoopActivationOutput.ReadOnly]
    def analyzeDocumentModelVersion: Optional[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getBlocks
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Block.ReadOnly]] =
      AwsError.unwrapOptionField("blocks", blocks)
    def getHumanLoopActivationOutput: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.HumanLoopActivationOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "humanLoopActivationOutput",
      humanLoopActivationOutput
    )
    def getAnalyzeDocumentModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "analyzeDocumentModelVersion",
        analyzeDocumentModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse
  ) extends zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly {
    override val documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Block.wrap(item)
          }.toList
        )
    override val humanLoopActivationOutput
        : Optional[zio.aws.textract.model.HumanLoopActivationOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanLoopActivationOutput())
        .map(value =>
          zio.aws.textract.model.HumanLoopActivationOutput.wrap(value)
        )
    override val analyzeDocumentModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzeDocumentModelVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse
  ): zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly = new Wrapper(impl)
}
