package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyzeExpenseResponse(
    documentMetadata: Optional[zio.aws.textract.model.DocumentMetadata] =
      Optional.Absent,
    expenseDocuments: Optional[
      Iterable[zio.aws.textract.model.ExpenseDocument]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse = {
    import AnalyzeExpenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(
        expenseDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expenseDocuments)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly =
    zio.aws.textract.model.AnalyzeExpenseResponse.wrap(buildAwsValue())
}
object AnalyzeExpenseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeExpenseResponse =
      zio.aws.textract.model.AnalyzeExpenseResponse(
        documentMetadata.map(value => value.asEditable),
        expenseDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def expenseDocuments
        : Optional[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getExpenseDocuments: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("expenseDocuments", expenseDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
  ) extends zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly {
    override val documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val expenseDocuments
        : Optional[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expenseDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.ExpenseDocument.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
  ): zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly = new Wrapper(impl)
}
