package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.Percent
import scala.jdk.CollectionConverters._
final case class ExpenseDetection(
    text: Optional[String] = Optional.Absent,
    geometry: Optional[zio.aws.textract.model.Geometry] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseDetection = {
    import ExpenseDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseDetection
      .builder()
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseDetection.ReadOnly =
    zio.aws.textract.model.ExpenseDetection.wrap(buildAwsValue())
}
object ExpenseDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseDetection =
      zio.aws.textract.model.ExpenseDetection(
        text.map(value => value),
        geometry.map(value => value.asEditable),
        confidence.map(value => value)
      )
    def text: Optional[String]
    def geometry: Optional[zio.aws.textract.model.Geometry.ReadOnly]
    def confidence: Optional[Percent]
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.textract.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDetection
  ) extends zio.aws.textract.model.ExpenseDetection.ReadOnly {
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val geometry: Optional[zio.aws.textract.model.Geometry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geometry())
        .map(value => zio.aws.textract.model.Geometry.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDetection
  ): zio.aws.textract.model.ExpenseDetection.ReadOnly = new Wrapper(impl)
}
