package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.Percent
import scala.jdk.CollectionConverters._
final case class ExpenseType(
    text: Optional[String] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseType = {
    import ExpenseType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseType
      .builder()
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseType.ReadOnly =
    zio.aws.textract.model.ExpenseType.wrap(buildAwsValue())
}
object ExpenseType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseType = zio.aws.textract.model
      .ExpenseType(text.map(value => value), confidence.map(value => value))
    def text: Optional[String]
    def confidence: Optional[Percent]
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseType
  ) extends zio.aws.textract.model.ExpenseType.ReadOnly {
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseType
  ): zio.aws.textract.model.ExpenseType.ReadOnly = new Wrapper(impl)
}
