package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.textract.model.primitives.{RoleArn, SNSTopicArn}
import scala.jdk.CollectionConverters._
final case class NotificationChannel(
    snsTopicArn: SNSTopicArn,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.NotificationChannel = {
    import NotificationChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.NotificationChannel
      .builder()
      .snsTopicArn(SNSTopicArn.unwrap(snsTopicArn): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.NotificationChannel.ReadOnly =
    zio.aws.textract.model.NotificationChannel.wrap(buildAwsValue())
}
object NotificationChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.NotificationChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.NotificationChannel =
      zio.aws.textract.model.NotificationChannel(snsTopicArn, roleArn)
    def snsTopicArn: SNSTopicArn
    def roleArn: RoleArn
    def getSnsTopicArn: ZIO[Any, Nothing, SNSTopicArn] =
      ZIO.succeed(snsTopicArn)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.NotificationChannel
  ) extends zio.aws.textract.model.NotificationChannel.ReadOnly {
    override val snsTopicArn: SNSTopicArn =
      zio.aws.textract.model.primitives.SNSTopicArn(impl.snsTopicArn())
    override val roleArn: RoleArn =
      zio.aws.textract.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.NotificationChannel
  ): zio.aws.textract.model.NotificationChannel.ReadOnly = new Wrapper(impl)
}
