package zio.aws.textract.model
import scala.jdk.CollectionConverters._
sealed trait SelectionStatus {
  def unwrap: software.amazon.awssdk.services.textract.model.SelectionStatus
}
object SelectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.SelectionStatus
  ): zio.aws.textract.model.SelectionStatus = value match {
    case software.amazon.awssdk.services.textract.model.SelectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.SelectionStatus.SELECTED =>
      val r = SELECTED
      r
    case software.amazon.awssdk.services.textract.model.SelectionStatus.NOT_SELECTED =>
      val r = NOT_SELECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.textract.model.SelectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.SelectionStatus =
      software.amazon.awssdk.services.textract.model.SelectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SELECTED extends zio.aws.textract.model.SelectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.SelectionStatus =
      software.amazon.awssdk.services.textract.model.SelectionStatus.SELECTED
  }
  case object NOT_SELECTED extends zio.aws.textract.model.SelectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.SelectionStatus =
      software.amazon.awssdk.services.textract.model.SelectionStatus.NOT_SELECTED
  }
}
