package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  DataAccessRoleArn,
  IdentifiedLanguageScore,
  FailureReason,
  MediaSampleRateHertz,
  DateTime,
  CallAnalyticsJobName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CallAnalyticsJob(
    callAnalyticsJobName: Optional[CallAnalyticsJobName] = Optional.Absent,
    callAnalyticsJobStatus: Optional[
      zio.aws.transcribe.model.CallAnalyticsJobStatus
    ] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    mediaSampleRateHertz: Optional[MediaSampleRateHertz] = Optional.Absent,
    mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      Optional.Absent,
    media: Optional[zio.aws.transcribe.model.Media] = Optional.Absent,
    transcript: Optional[zio.aws.transcribe.model.Transcript] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    completionTime: Optional[DateTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    dataAccessRoleArn: Optional[DataAccessRoleArn] = Optional.Absent,
    identifiedLanguageScore: Optional[IdentifiedLanguageScore] =
      Optional.Absent,
    settings: Optional[zio.aws.transcribe.model.CallAnalyticsJobSettings] =
      Optional.Absent,
    channelDefinitions: Optional[
      Iterable[zio.aws.transcribe.model.ChannelDefinition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJob = {
    import CallAnalyticsJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CallAnalyticsJob
      .builder()
      .optionallyWith(
        callAnalyticsJobName.map(value =>
          CallAnalyticsJobName.unwrap(value): java.lang.String
        )
      )(_.callAnalyticsJobName)
      .optionallyWith(callAnalyticsJobStatus.map(value => value.unwrap))(
        _.callAnalyticsJobStatus
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .optionallyWith(media.map(value => value.buildAwsValue()))(_.media)
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          DataAccessRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        identifiedLanguageScore.map(value =>
          IdentifiedLanguageScore.unwrap(value): java.lang.Float
        )
      )(_.identifiedLanguageScore)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(
        channelDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelDefinitions)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly =
    zio.aws.transcribe.model.CallAnalyticsJob.wrap(buildAwsValue())
}
object CallAnalyticsJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CallAnalyticsJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CallAnalyticsJob =
      zio.aws.transcribe.model.CallAnalyticsJob(
        callAnalyticsJobName.map(value => value),
        callAnalyticsJobStatus.map(value => value),
        languageCode.map(value => value),
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.map(value => value.asEditable),
        transcript.map(value => value.asEditable),
        startTime.map(value => value),
        creationTime.map(value => value),
        completionTime.map(value => value),
        failureReason.map(value => value),
        dataAccessRoleArn.map(value => value),
        identifiedLanguageScore.map(value => value),
        settings.map(value => value.asEditable),
        channelDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def callAnalyticsJobName: Optional[CallAnalyticsJobName]
    def callAnalyticsJobStatus
        : Optional[zio.aws.transcribe.model.CallAnalyticsJobStatus]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def mediaSampleRateHertz: Optional[MediaSampleRateHertz]
    def mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat]
    def media: Optional[zio.aws.transcribe.model.Media.ReadOnly]
    def transcript: Optional[zio.aws.transcribe.model.Transcript.ReadOnly]
    def startTime: Optional[DateTime]
    def creationTime: Optional[DateTime]
    def completionTime: Optional[DateTime]
    def failureReason: Optional[FailureReason]
    def dataAccessRoleArn: Optional[DataAccessRoleArn]
    def identifiedLanguageScore: Optional[IdentifiedLanguageScore]
    def settings
        : Optional[zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly]
    def channelDefinitions
        : Optional[List[zio.aws.transcribe.model.ChannelDefinition.ReadOnly]]
    def getCallAnalyticsJobName: ZIO[Any, AwsError, CallAnalyticsJobName] =
      AwsError.unwrapOptionField("callAnalyticsJobName", callAnalyticsJobName)
    def getCallAnalyticsJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      AwsError.unwrapOptionField(
        "callAnalyticsJobStatus",
        callAnalyticsJobStatus
      )
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz: ZIO[Any, AwsError, MediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, AwsError, zio.aws.transcribe.model.Media.ReadOnly] =
      AwsError.unwrapOptionField("media", media)
    def getTranscript
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Transcript.ReadOnly] =
      AwsError.unwrapOptionField("transcript", transcript)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDataAccessRoleArn: ZIO[Any, AwsError, DataAccessRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getIdentifiedLanguageScore
        : ZIO[Any, AwsError, IdentifiedLanguageScore] = AwsError
      .unwrapOptionField("identifiedLanguageScore", identifiedLanguageScore)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getChannelDefinitions: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.ChannelDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("channelDefinitions", channelDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CallAnalyticsJob
  ) extends zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly {
    override val callAnalyticsJobName: Optional[CallAnalyticsJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAnalyticsJobName())
        .map(value =>
          zio.aws.transcribe.model.primitives.CallAnalyticsJobName(value)
        )
    override val callAnalyticsJobStatus
        : Optional[zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAnalyticsJobStatus())
        .map(value =>
          zio.aws.transcribe.model.CallAnalyticsJobStatus.wrap(value)
        )
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: Optional[MediaSampleRateHertz] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaSampleRateHertz())
        .map(value =>
          zio.aws.transcribe.model.primitives.MediaSampleRateHertz(value)
        )
    override val mediaFormat: Optional[zio.aws.transcribe.model.MediaFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: Optional[zio.aws.transcribe.model.Media.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.media())
        .map(value => zio.aws.transcribe.model.Media.wrap(value))
    override val transcript
        : Optional[zio.aws.transcribe.model.Transcript.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcript())
        .map(value => zio.aws.transcribe.model.Transcript.wrap(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val dataAccessRoleArn: Optional[DataAccessRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRoleArn())
        .map(value =>
          zio.aws.transcribe.model.primitives.DataAccessRoleArn(value)
        )
    override val identifiedLanguageScore: Optional[IdentifiedLanguageScore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifiedLanguageScore())
        .map(value =>
          zio.aws.transcribe.model.primitives.IdentifiedLanguageScore(value)
        )
    override val settings
        : Optional[zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          zio.aws.transcribe.model.CallAnalyticsJobSettings.wrap(value)
        )
    override val channelDefinitions
        : Optional[List[zio.aws.transcribe.model.ChannelDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.ChannelDefinition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CallAnalyticsJob
  ): zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly = new Wrapper(impl)
}
