package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.ChannelId
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ChannelDefinition(
    channelId: Optional[ChannelId] = Optional.Absent,
    participantRole: Optional[zio.aws.transcribe.model.ParticipantRole] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ChannelDefinition = {
    import ChannelDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ChannelDefinition
      .builder()
      .optionallyWith(channelId.map(value => ChannelId.unwrap(value): Integer))(
        _.channelId
      )
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ChannelDefinition.ReadOnly =
    zio.aws.transcribe.model.ChannelDefinition.wrap(buildAwsValue())
}
object ChannelDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ChannelDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ChannelDefinition =
      zio.aws.transcribe.model.ChannelDefinition(
        channelId.map(value => value),
        participantRole.map(value => value)
      )
    def channelId: Optional[ChannelId]
    def participantRole: Optional[zio.aws.transcribe.model.ParticipantRole]
    def getChannelId: ZIO[Any, AwsError, ChannelId] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getParticipantRole
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ParticipantRole] =
      AwsError.unwrapOptionField("participantRole", participantRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ChannelDefinition
  ) extends zio.aws.transcribe.model.ChannelDefinition.ReadOnly {
    override val channelId: Optional[ChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.channelId())
      .map(value => zio.aws.transcribe.model.primitives.ChannelId(value))
    override val participantRole
        : Optional[zio.aws.transcribe.model.ParticipantRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantRole())
        .map(value => zio.aws.transcribe.model.ParticipantRole.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ChannelDefinition
  ): zio.aws.transcribe.model.ChannelDefinition.ReadOnly = new Wrapper(impl)
}
