package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  DataAccessRoleArn,
  Uri,
  Word,
  VocabularyFilterName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVocabularyFilterRequest(
    vocabularyFilterName: VocabularyFilterName,
    languageCode: zio.aws.transcribe.model.LanguageCode,
    words: Optional[Iterable[Word]] = Optional.Absent,
    vocabularyFilterFileUri: Optional[Uri] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transcribe.model.Tag]] = Optional.Absent,
    dataAccessRoleArn: Optional[DataAccessRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest = {
    import CreateVocabularyFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest
      .builder()
      .vocabularyFilterName(
        VocabularyFilterName.unwrap(vocabularyFilterName): java.lang.String
      )
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        words.map(value =>
          value.map { item =>
            Word.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.words)
      .optionallyWith(
        vocabularyFilterFileUri.map(value =>
          Uri.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterFileUri)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          DataAccessRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.CreateVocabularyFilterRequest.ReadOnly =
    zio.aws.transcribe.model.CreateVocabularyFilterRequest.wrap(buildAwsValue())
}
object CreateVocabularyFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CreateVocabularyFilterRequest =
      zio.aws.transcribe.model.CreateVocabularyFilterRequest(
        vocabularyFilterName,
        languageCode,
        words.map(value => value),
        vocabularyFilterFileUri.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataAccessRoleArn.map(value => value)
      )
    def vocabularyFilterName: VocabularyFilterName
    def languageCode: zio.aws.transcribe.model.LanguageCode
    def words: Optional[List[Word]]
    def vocabularyFilterFileUri: Optional[Uri]
    def tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def dataAccessRoleArn: Optional[DataAccessRoleArn]
    def getVocabularyFilterName: ZIO[Any, Nothing, VocabularyFilterName] =
      ZIO.succeed(vocabularyFilterName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getWords: ZIO[Any, AwsError, List[Word]] =
      AwsError.unwrapOptionField("words", words)
    def getVocabularyFilterFileUri: ZIO[Any, AwsError, Uri] = AwsError
      .unwrapOptionField("vocabularyFilterFileUri", vocabularyFilterFileUri)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDataAccessRoleArn: ZIO[Any, AwsError, DataAccessRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest
  ) extends zio.aws.transcribe.model.CreateVocabularyFilterRequest.ReadOnly {
    override val vocabularyFilterName: VocabularyFilterName =
      zio.aws.transcribe.model.primitives
        .VocabularyFilterName(impl.vocabularyFilterName())
    override val languageCode: zio.aws.transcribe.model.LanguageCode =
      zio.aws.transcribe.model.LanguageCode.wrap(impl.languageCode())
    override val words: Optional[List[Word]] = zio.aws.core.internal
      .optionalFromNullable(impl.words())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.primitives.Word(item)
        }.toList
      )
    override val vocabularyFilterFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilterFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
    override val tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
    override val dataAccessRoleArn: Optional[DataAccessRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRoleArn())
        .map(value =>
          zio.aws.transcribe.model.primitives.DataAccessRoleArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest
  ): zio.aws.transcribe.model.CreateVocabularyFilterRequest.ReadOnly =
    new Wrapper(impl)
}
