package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.ModelName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLanguageModelRequest(modelName: ModelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest = {
    import DescribeLanguageModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DescribeLanguageModelRequest.ReadOnly =
    zio.aws.transcribe.model.DescribeLanguageModelRequest.wrap(buildAwsValue())
}
object DescribeLanguageModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DescribeLanguageModelRequest =
      zio.aws.transcribe.model.DescribeLanguageModelRequest(modelName)
    def modelName: ModelName
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest
  ) extends zio.aws.transcribe.model.DescribeLanguageModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.transcribe.model.primitives.ModelName(impl.modelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest
  ): zio.aws.transcribe.model.DescribeLanguageModelRequest.ReadOnly =
    new Wrapper(impl)
}
