package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCallAnalyticsJobResponse(
    callAnalyticsJob: Optional[zio.aws.transcribe.model.CallAnalyticsJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse = {
    import GetCallAnalyticsJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse
      .builder()
      .optionallyWith(callAnalyticsJob.map(value => value.buildAwsValue()))(
        _.callAnalyticsJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly =
    zio.aws.transcribe.model.GetCallAnalyticsJobResponse.wrap(buildAwsValue())
}
object GetCallAnalyticsJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetCallAnalyticsJobResponse =
      zio.aws.transcribe.model.GetCallAnalyticsJobResponse(
        callAnalyticsJob.map(value => value.asEditable)
      )
    def callAnalyticsJob
        : Optional[zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly]
    def getCallAnalyticsJob: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly
    ] = AwsError.unwrapOptionField("callAnalyticsJob", callAnalyticsJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse
  ) extends zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly {
    override val callAnalyticsJob
        : Optional[zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAnalyticsJob())
        .map(value => zio.aws.transcribe.model.CallAnalyticsJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse
  ): zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly =
    new Wrapper(impl)
}
