package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TranscriptionJobName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMedicalTranscriptionJobRequest(
    medicalTranscriptionJobName: TranscriptionJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest = {
    import GetMedicalTranscriptionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest
      .builder()
      .medicalTranscriptionJobName(
        TranscriptionJobName.unwrap(
          medicalTranscriptionJobName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest.ReadOnly =
    zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest
      .wrap(buildAwsValue())
}
object GetMedicalTranscriptionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest =
      zio.aws.transcribe.model
        .GetMedicalTranscriptionJobRequest(medicalTranscriptionJobName)
    def medicalTranscriptionJobName: TranscriptionJobName
    def getMedicalTranscriptionJobName
        : ZIO[Any, Nothing, TranscriptionJobName] =
      ZIO.succeed(medicalTranscriptionJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest
  ) extends zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest.ReadOnly {
    override val medicalTranscriptionJobName: TranscriptionJobName =
      zio.aws.transcribe.model.primitives
        .TranscriptionJobName(impl.medicalTranscriptionJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest
  ): zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest.ReadOnly =
    new Wrapper(impl)
}
