package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  Uri,
  FailureReason,
  DateTime,
  VocabularyName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetMedicalVocabularyResponse(
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    vocabularyState: Optional[zio.aws.transcribe.model.VocabularyState] =
      Optional.Absent,
    lastModifiedTime: Optional[DateTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    downloadUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse = {
    import GetMedicalVocabularyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse
      .builder()
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(vocabularyState.map(value => value.unwrap))(
        _.vocabularyState
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        downloadUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.downloadUri)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly =
    zio.aws.transcribe.model.GetMedicalVocabularyResponse.wrap(buildAwsValue())
}
object GetMedicalVocabularyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetMedicalVocabularyResponse =
      zio.aws.transcribe.model.GetMedicalVocabularyResponse(
        vocabularyName.map(value => value),
        languageCode.map(value => value),
        vocabularyState.map(value => value),
        lastModifiedTime.map(value => value),
        failureReason.map(value => value),
        downloadUri.map(value => value)
      )
    def vocabularyName: Optional[VocabularyName]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def vocabularyState: Optional[zio.aws.transcribe.model.VocabularyState]
    def lastModifiedTime: Optional[DateTime]
    def failureReason: Optional[FailureReason]
    def downloadUri: Optional[Uri]
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getVocabularyState
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyState] =
      AwsError.unwrapOptionField("vocabularyState", vocabularyState)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDownloadUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("downloadUri", downloadUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse
  ) extends zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly {
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val vocabularyState
        : Optional[zio.aws.transcribe.model.VocabularyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyState())
        .map(value => zio.aws.transcribe.model.VocabularyState.wrap(value))
    override val lastModifiedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val downloadUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.downloadUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse
  ): zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly =
    new Wrapper(impl)
}
