package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.VocabularyName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVocabularyRequest(vocabularyName: VocabularyName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest = {
    import GetVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.GetVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.GetVocabularyRequest.wrap(buildAwsValue())
}
object GetVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetVocabularyRequest =
      zio.aws.transcribe.model.GetVocabularyRequest(vocabularyName)
    def vocabularyName: VocabularyName
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest
  ) extends zio.aws.transcribe.model.GetVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest
  ): zio.aws.transcribe.model.GetVocabularyRequest.ReadOnly = new Wrapper(impl)
}
