package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  MaxResults,
  NextToken,
  CallAnalyticsJobName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCallAnalyticsJobsRequest(
    status: Optional[zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      Optional.Absent,
    jobNameContains: Optional[CallAnalyticsJobName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest = {
    import ListCallAnalyticsJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        jobNameContains.map(value =>
          CallAnalyticsJobName.unwrap(value): java.lang.String
        )
      )(_.jobNameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.ReadOnly =
    zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.wrap(buildAwsValue())
}
object ListCallAnalyticsJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest =
      zio.aws.transcribe.model.ListCallAnalyticsJobsRequest(
        status.map(value => value),
        jobNameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def status: Optional[zio.aws.transcribe.model.CallAnalyticsJobStatus]
    def jobNameContains: Optional[CallAnalyticsJobName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getJobNameContains: ZIO[Any, AwsError, CallAnalyticsJobName] =
      AwsError.unwrapOptionField("jobNameContains", jobNameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
  ) extends zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.ReadOnly {
    override val status
        : Optional[zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.transcribe.model.CallAnalyticsJobStatus.wrap(value)
        )
    override val jobNameContains: Optional[CallAnalyticsJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobNameContains())
        .map(value =>
          zio.aws.transcribe.model.primitives.CallAnalyticsJobName(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest
  ): zio.aws.transcribe.model.ListCallAnalyticsJobsRequest.ReadOnly =
    new Wrapper(impl)
}
