package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{MaxResults, NextToken, ModelName}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLanguageModelsRequest(
    statusEquals: Optional[zio.aws.transcribe.model.ModelStatus] =
      Optional.Absent,
    nameContains: Optional[ModelName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest = {
    import ListLanguageModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
      .builder()
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        nameContains.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ListLanguageModelsRequest.ReadOnly =
    zio.aws.transcribe.model.ListLanguageModelsRequest.wrap(buildAwsValue())
}
object ListLanguageModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListLanguageModelsRequest =
      zio.aws.transcribe.model.ListLanguageModelsRequest(
        statusEquals.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def statusEquals: Optional[zio.aws.transcribe.model.ModelStatus]
    def nameContains: Optional[ModelName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getNameContains: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
  ) extends zio.aws.transcribe.model.ListLanguageModelsRequest.ReadOnly {
    override val statusEquals: Optional[zio.aws.transcribe.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.transcribe.model.ModelStatus.wrap(value))
    override val nameContains: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.transcribe.model.primitives.ModelName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
  ): zio.aws.transcribe.model.ListLanguageModelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
