package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TranscribeArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: TranscribeArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(TranscribeArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.transcribe.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListTagsForResourceRequest =
      zio.aws.transcribe.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: TranscribeArn
    def getResourceArn: ZIO[Any, Nothing, TranscribeArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest
  ) extends zio.aws.transcribe.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: TranscribeArn =
      zio.aws.transcribe.model.primitives.TranscribeArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest
  ): zio.aws.transcribe.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
