package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  VocabularyFilterName,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVocabularyFiltersRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nameContains: Optional[VocabularyFilterName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest = {
    import ListVocabularyFiltersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListVocabularyFiltersRequest.ReadOnly =
    zio.aws.transcribe.model.ListVocabularyFiltersRequest.wrap(buildAwsValue())
}
object ListVocabularyFiltersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListVocabularyFiltersRequest =
      zio.aws.transcribe.model.ListVocabularyFiltersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def nameContains: Optional[VocabularyFilterName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
  ) extends zio.aws.transcribe.model.ListVocabularyFiltersRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
    override val nameContains: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
  ): zio.aws.transcribe.model.ListVocabularyFiltersRequest.ReadOnly =
    new Wrapper(impl)
}
